using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Net.Mail;
using System.IO;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {   
        if (!IsPostBack)
        {
            txtStartDate.Text = System.DateTime.Today.ToShortDateString();
            txtEndDate.Text = System.DateTime.Today.ToShortDateString();
            txtStartTime.Text = "11:00";
            txtEndTime.Text = "12:00";
        }
    }

    protected void chkAllDay_CheckedChanged(object sender, EventArgs e)
    {
        if (chkAllDay.Checked)
        {
            txtStartTime.Enabled = false;
            txtEndTime.Enabled = false;
        }
        else
        {
            txtStartTime.Enabled = true;
            txtEndTime.Enabled = true;
        }
    }
    protected void btnSendEvent_Click(object sender, EventArgs e)
    {
        string fileName = string.Empty;
        Appointment appointment = new Appointment();
        if (chkAllDay.Checked)
        {       
            fileName = appointment.MakeDayEvent(txtSubject.Text, txtLocation.Text, Convert.ToDateTime(txtStartDate.Text), Convert.ToDateTime(txtEndDate.Text));
            Attachment attachment = new Attachment(fileName);
            SendMail("me@ashrafur.com", txtTo.Text, txtSubject.Text, txtMessage.Text, attachment);
            if (File.Exists(fileName))
            {
                File.Delete(fileName);
            }
        }
        else
        {
            if (txtStartDate.Text.Equals(txtEndDate.Text))
            {
                fileName = appointment.MakeHourEvent(txtSubject.Text, txtLocation.Text, Convert.ToDateTime(txtStartDate.Text), txtStartTime.Text, txtEndTime.Text);
                Attachment attachment = new Attachment(fileName);
                SendMail("me@ashrafur.com", txtTo.Text, txtSubject.Text, txtMessage.Text, attachment);
                if (File.Exists(fileName))
                {
                    File.Delete(fileName);
                }
            }
            else
            {
                lblError.Text = "Different date can create day event";
                txtEndDate.Text = txtStartDate.Text;
            }           
        }
    }
    public void SendMail(string from, string to, string subject, string body, Attachment attachment)
    {
        MailMessage mail = new MailMessage(from, to, subject, body);
        mail.Attachments.Add(attachment);
        SmtpClient smtp = new SmtpClient("localhost");
        smtp.Send(mail);
        mail.Dispose();
    }
}