/*
 * Decompiled with CFR 0.152.
 */
package beans;

import beans.AgendaDay;
import beans.AgendaPanel;
import beans.AgendaUser;
import beans.TimeHourMinute;
import business.EventUtil;
import commons.Constants;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tables.EbEvents;
import tables.EbWorktimetable;

public class AgendaWeek
extends JPanel {
    private Calendar dateOfDay;
    private Calendar endOfWeek;
    private List<AgendaDay> dayList;
    private List<AgendaUser> userList;
    private List<EbEvents> preciseList;
    private List<JLabel> labelList;
    private GridBagConstraints gridBagConstraints;
    private AgendaPanel parentAgenda;
    private JLabel lbUserName;
    private JLabel lbUserTime;
    private Color color;
    private static boolean colorFlag = false;

    public AgendaWeek(AgendaPanel parent, Calendar startOfWeek, List<EbEvents> ebEventsList, List<AgendaUser> userList) {
        this.parentAgenda = parent;
        this.lbUserName = new JLabel();
        this.endOfWeek = Calendar.getInstance(Locale.FRANCE);
        this.endOfWeek.setTimeInMillis(startOfWeek.getTimeInMillis());
        this.endOfWeek.add(6, 7);
        this.color = this.getBackground();
        this.userList = userList;
        this.dayList = new ArrayList<AgendaDay>();
        this.labelList = new ArrayList<JLabel>();
        this.setLayout(new GridLayout(userList.size() + 1, 8));
        this.setLayout(new GridBagLayout());
        this.preciseList = EventUtil.preciseEventList(startOfWeek, this.endOfWeek, ebEventsList);
        this.dateOfDay = Calendar.getInstance(Locale.FRANCE);
        this.dateOfDay.setTimeInMillis(startOfWeek.getTimeInMillis());
        JPanel userHeaderPanel = new JPanel();
        JLabel userHeader = new JLabel("semaine " + this.dateOfDay.get(3));
        userHeader.setBorder(BorderFactory.createEtchedBorder());
        userHeaderPanel.add(userHeader);
        this.add(userHeaderPanel);
        for (int i = 0; i < 7; ++i) {
            String date = "<html><body><center>" + Constants.DAY_OF_WEEK[i] + "<br>" + this.dateOfDay.get(5) + "-" + (this.dateOfDay.get(2) + 1) + "-" + this.dateOfDay.get(1) + "</center></body></html>";
            JPanel dayHeaderPanel = new JPanel();
            JLabel dayHeader = new JLabel(date);
            dayHeaderPanel.setLayout(new BoxLayout(dayHeaderPanel, 3));
            dayHeaderPanel.add(dayHeader);
            dayHeader.setBorder(BorderFactory.createEtchedBorder());
            this.gridBagConstraints = new GridBagConstraints();
            this.gridBagConstraints.gridx = i + 1;
            this.gridBagConstraints.gridy = 0;
            this.gridBagConstraints.weightx = 1.0;
            this.gridBagConstraints.fill = 1;
            this.gridBagConstraints.anchor = 23;
            this.add((Component)dayHeaderPanel, this.gridBagConstraints);
            this.dateOfDay.add(6, 1);
        }
        this.dateOfDay.setTimeInMillis(startOfWeek.getTimeInMillis());
        for (int j = 0; j < userList.size(); ++j) {
            if (!colorFlag) {
                this.color = new Color(210, 210, 210);
                colorFlag = !colorFlag;
            } else {
                this.color = new Color(240, 240, 240);
                colorFlag = !colorFlag;
            }
            this.gridBagConstraints = new GridBagConstraints();
            this.gridBagConstraints.gridx = 0;
            this.gridBagConstraints.anchor = 23;
            this.gridBagConstraints.weightx = 1.0;
            this.gridBagConstraints.weighty = 1.0;
            this.gridBagConstraints.fill = 1;
            this.lbUserName = new JLabel(userList.get(j).getInitiales());
            this.lbUserName.setOpaque(true);
            this.lbUserName.setBackground(this.color);
            this.lbUserTime = new JLabel();
            this.labelList.add(this.lbUserTime);
            this.add((Component)this.lbUserTime, this.gridBagConstraints);
            TimeHourMinute timeOfWeek = new TimeHourMinute();
            TimeHourMinute timeOfWeekRemaining = new TimeHourMinute(38);
            for (int i = 0; i < 7; ++i) {
                Calendar newCal = Calendar.getInstance(Locale.FRANCE);
                newCal.setTimeInMillis(this.dateOfDay.getTimeInMillis());
                AgendaDay aDay = this.preciseList.isEmpty() ? new AgendaDay(this, newCal, userList.get(j)) : new AgendaDay(this, newCal, this.preciseList, userList.get(j));
                this.gridBagConstraints = new GridBagConstraints();
                this.gridBagConstraints.gridx = i + 1;
                this.gridBagConstraints.anchor = 23;
                this.gridBagConstraints.weightx = 1.0;
                this.gridBagConstraints.weighty = 1.0;
                this.gridBagConstraints.fill = 1;
                this.dayList.add(aDay);
                this.add((Component)aDay, this.gridBagConstraints);
                this.dateOfDay.add(6, 1);
                TimeHourMinute timeOfDay = aDay.computeWorkTime();
                EbWorktimetable wtt = EventUtil.getWorkTime(aDay.getUser().getId(), this.dateOfDay);
                if (wtt == null) {
                    wtt = EventUtil.addWorkTime(aDay.getUser().getId(), this.dateOfDay, timeOfDay.getHour(), timeOfDay.getMinute());
                }
                timeOfWeek = timeOfWeek.addTHM(timeOfDay);
            }
            timeOfWeekRemaining = timeOfWeekRemaining.subTHM(timeOfWeek);
            TimeHourMinute credit = new TimeHourMinute();
            credit.setHour(timeOfWeek.getHour() - 38);
            credit.setMinute(timeOfWeek.getMinute());
            timeOfWeekRemaining.setHour(0);
            timeOfWeekRemaining.setMinute(0);
            this.lbUserTime.setText("<html><body><b>" + userList.get(j).getInitiales() + "</b><br>" + "Temps de travail<br>cette semaine: <b>" + timeOfWeek.toString() + "</b><br>Temps de travail<br>restant: <b>" + timeOfWeekRemaining.toString() + "</b>" + "<br>Cr\u00e9dit <b>: " + credit.toString() + "</b></body></html>");
            this.dateOfDay.setTimeInMillis(startOfWeek.getTimeInMillis());
        }
    }

    public void reloadWeek(List<EbEvents> ebEventsList) {
        List<EbEvents> rePreciseList = EventUtil.preciseEventList(this.dateOfDay, this.endOfWeek, ebEventsList);
        if (!rePreciseList.equals(this.preciseList)) {
            for (EbEvents event : rePreciseList) {
            }
            for (int j = 0; j < this.userList.size(); ++j) {
                if (!colorFlag) {
                    this.color = new Color(210, 210, 210);
                    colorFlag = !colorFlag;
                } else {
                    this.color = new Color(240, 240, 240);
                    colorFlag = !colorFlag;
                }
                TimeHourMinute timeOfWeek = new TimeHourMinute();
                TimeHourMinute timeOfWeekRemaining = new TimeHourMinute(38);
                boolean cpt = false;
                for (int k = j * 7; k < j * 7 + 6; ++k) {
                    Calendar newCal = Calendar.getInstance(Locale.FRANCE);
                    newCal.setTimeInMillis(this.dateOfDay.getTimeInMillis());
                    this.dayList.get(k).reloadDay(rePreciseList);
                    TimeHourMinute timeOfDay = this.dayList.get(k).computeWorkTime();
                    EbWorktimetable wtt = EventUtil.getWorkTime(this.dayList.get(k).getUser().getId(), this.dateOfDay);
                    if (wtt == null) {
                        wtt = EventUtil.addWorkTime(this.dayList.get(k).getUser().getId(), this.dateOfDay, timeOfDay.getHour(), timeOfDay.getMinute());
                    }
                    timeOfWeek = timeOfWeek.addTHM(timeOfDay);
                }
                timeOfWeekRemaining = timeOfWeekRemaining.subTHM(timeOfWeek);
                TimeHourMinute credit = new TimeHourMinute();
                credit.setHour(timeOfWeek.getHour() - 38);
                credit.setMinute(timeOfWeek.getMinute());
                timeOfWeekRemaining.setHour(0);
                timeOfWeekRemaining.setMinute(0);
                this.labelList.get(j).setText("<html><body><b>" + this.userList.get(j).getInitiales() + "</b><br>" + "Temps de travail<br>cette semaine: <b>" + timeOfWeek.toString() + "</b><br>Temps de travail<br>restant: <b>" + timeOfWeekRemaining.toString() + "</b>" + "<br>Cr\u00e9dit : <b>" + credit.toString() + "</b></body></html>");
            }
        }
    }

    public Color getColor() {
        return this.color;
    }

    public AgendaPanel getParentAgenda() {
        return this.parentAgenda;
    }

    public List<AgendaUser> getUserList() {
        return this.userList;
    }
}

