/*
 * Decompiled with CFR 0.152.
 */
package beans;

import beans.DateTimeBean;
import business.EventUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import tables.EbCli;
import tables.Employees;
import ui.TestApplet;

public class AgendaNewEvent
extends JPanel {
    private List<JCheckBox> userCheckBoxes = new ArrayList<JCheckBox>();
    private List<EbCli> cliList;
    private JFrame parent;
    private Calendar start;
    private Calendar end;
    private JButton btCancel;
    private JButton btCreateEvent;
    private JPanel btPanel;
    private JCheckBox ckBoxFullDay;
    private JPanel cliPanel;
    private JPanel contentPanel;
    private JPanel descPanel;
    private JPanel endDatePanel;
    private DateTimeBean endTimeBean;
    private JTextField fieldEventName;
    private JComboBox jComboBox1;
    private JScrollPane jScrollPane1;
    private JPanel startDatePanel;
    private DateTimeBean startTimeBean;
    private JLabel title;
    private JPanel titlePanel;
    private JTextArea txtEventDesc;
    private JPanel userPanel;
    private JPanel usersPanel;

    public AgendaNewEvent(Calendar date, JFrame parent) {
        this.initComponents();
        this.parent = parent;
        this.start = Calendar.getInstance(Locale.FRANCE);
        this.end = Calendar.getInstance(Locale.FRANCE);
        this.start.setTimeInMillis(date.getTimeInMillis());
        this.end.setTimeInMillis(date.getTimeInMillis());
        this.end.set(11, this.start.get(11) + 1);
        this.startTimeBean.setDateTime(this.start);
        this.endTimeBean.setDateTime(this.end);
        this.populateUsers();
    }

    private void populateUsers() {
        for (Employees emp : TestApplet.empList) {
            JCheckBox ckb = new JCheckBox();
            ckb.setText(emp.getInitiales());
            this.userCheckBoxes.add(ckb);
        }
        for (JCheckBox ckb : this.userCheckBoxes) {
            this.userPanel.add(ckb);
        }
    }

    public Calendar getStartTime() {
        System.out.println(this.startTimeBean.getDateTime().getTime());
        return this.startTimeBean.getDateTime();
    }

    public Calendar getEndTime() {
        return this.endTimeBean.getDateTime();
    }

    public EbCli getClient() {
        return (EbCli)this.jComboBox1.getSelectedItem();
    }

    public String getEventName() {
        return this.fieldEventName.getText();
    }

    public String getEventDesc() {
        return this.txtEventDesc.getText();
    }

    public Employees[] getEmployees() {
        ArrayList<Employees> participants = new ArrayList<Employees>();
        for (Component o : this.userPanel.getComponents()) {
            if (!(o instanceof JCheckBox)) continue;
            JCheckBox ckb = (JCheckBox)o;
            String initiales = ckb.getText();
            if (!ckb.isSelected() || !TestApplet.empMap.containsKey(initiales)) continue;
            Employees emp = TestApplet.empMap.get(initiales);
            participants.add(emp);
        }
        System.out.println(participants.size() + " participants");
        return participants.toArray(new Employees[0]);
    }

    private Object[] populateClients() {
        this.cliList = EventUtil.getClients();
        return this.cliList.toArray();
    }

    private void initComponents() {
        this.title = new JLabel();
        this.contentPanel = new JPanel();
        this.titlePanel = new JPanel();
        this.fieldEventName = new JTextField();
        this.ckBoxFullDay = new JCheckBox();
        this.startDatePanel = new JPanel();
        this.startTimeBean = new DateTimeBean();
        this.endDatePanel = new JPanel();
        this.endTimeBean = new DateTimeBean();
        this.usersPanel = new JPanel();
        this.userPanel = new JPanel();
        this.cliPanel = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.descPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.txtEventDesc = new JTextArea();
        this.btPanel = new JPanel();
        this.btCreateEvent = new JButton();
        this.btCancel = new JButton();
        this.setLayout(new BorderLayout());
        this.title.setText("Nouvel \u00e9v\u00e8nement");
        this.add((Component)this.title, "First");
        this.contentPanel.setLayout(new GridBagLayout());
        this.titlePanel.setBorder(BorderFactory.createTitledBorder("Titre"));
        this.titlePanel.setLayout(new BoxLayout(this.titlePanel, 2));
        this.titlePanel.add(this.fieldEventName);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.titlePanel, gridBagConstraints);
        this.ckBoxFullDay.setText("Journ\u00e9e Enti\u00e8re");
        this.ckBoxFullDay.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AgendaNewEvent.this.ckBoxFullDayActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        this.contentPanel.add((Component)this.ckBoxFullDay, gridBagConstraints);
        this.startDatePanel.setBorder(BorderFactory.createTitledBorder("D\u00e9but"));
        this.startDatePanel.setLayout(new BoxLayout(this.startDatePanel, 2));
        this.startDatePanel.add(this.startTimeBean);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 1;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.startDatePanel, gridBagConstraints);
        this.endDatePanel.setBorder(BorderFactory.createTitledBorder("Fin"));
        this.endDatePanel.setLayout(new BoxLayout(this.endDatePanel, 2));
        this.endDatePanel.add(this.endTimeBean);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.endDatePanel, gridBagConstraints);
        this.usersPanel.setBorder(BorderFactory.createTitledBorder("Participants"));
        this.usersPanel.setLayout(new BoxLayout(this.usersPanel, 2));
        this.userPanel.setLayout(new GridLayout(0, 6));
        this.usersPanel.add(this.userPanel);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.usersPanel, gridBagConstraints);
        this.cliPanel.setBorder(BorderFactory.createTitledBorder("Client"));
        this.cliPanel.setLayout(new BoxLayout(this.cliPanel, 2));
        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(this.populateClients()));
        this.cliPanel.add(this.jComboBox1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.cliPanel, gridBagConstraints);
        this.descPanel.setBorder(BorderFactory.createTitledBorder("Description"));
        this.descPanel.setLayout(new BoxLayout(this.descPanel, 2));
        this.txtEventDesc.setColumns(20);
        this.txtEventDesc.setRows(5);
        this.jScrollPane1.setViewportView(this.txtEventDesc);
        this.descPanel.add(this.jScrollPane1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.descPanel, gridBagConstraints);
        this.btPanel.setLayout(new GridBagLayout());
        this.btCreateEvent.setText("Cr\u00e9er");
        this.btCreateEvent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AgendaNewEvent.this.btCreateEventActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.btPanel.add((Component)this.btCreateEvent, gridBagConstraints);
        this.btCancel.setText("Annuler");
        this.btCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AgendaNewEvent.this.btCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.btPanel.add((Component)this.btCancel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.contentPanel.add((Component)this.btPanel, gridBagConstraints);
        this.add((Component)this.contentPanel, "Center");
    }

    private void ckBoxFullDayActionPerformed(ActionEvent evt) {
        this.start.set(11, 9);
        this.end.set(11, 17);
        this.startTimeBean.setDateTime(this.start);
        this.endTimeBean.setDateTime(this.end);
        this.startTimeBean.setEnabled(!this.ckBoxFullDay.isSelected());
        this.endTimeBean.setEnabled(!this.ckBoxFullDay.isSelected());
    }

    private void btCreateEventActionPerformed(ActionEvent evt) {
        EventUtil.addEvent(this.getEventName(), this.getEventDesc(), this.getStartTime(), this.getEndTime(), this.getClient().getIdebCli(), this.getEmployees(), this.ckBoxFullDay.isSelected());
        EventUtil.gettApp().reload();
        this.parent.dispose();
    }

    private void btCancelActionPerformed(ActionEvent evt) {
        this.parent.dispose();
    }
}

