# declare sql in a variable and pass it to -Query switch


$outfile = "C:\METALPRO.NET\B2K.NET\Scripts\exportCLF\Export\STOMOV.csv" # name of file
$sql="select MovementID, FORMAT(Date, N'dd/MM/yyyy') as movdata, FORMAT(Date, N'HH:mm:ss') as movora, mov.StateEnum as movop, FlagEnum as movflag, 
mov.EmployeeID as movcli, mov.ModelSizeID, mds.Code as movmod, mov.UseTypeEnum, mov.GarmentID, gar.ChipCode as movart, StartTime as movtimei, EndTime as movtimee, mov.StorageID, sto.Code as movmag,
mov.StoragePointID, stp.Identification as StoragePoint, ProgressiveCMD as movprogre, mov.SlotNumber as movcas
from Movements as mov join Garments as gar on mov.GarmentID=gar.GarmentID left join Storages as sto on sto.StorageID=mov.StorageID 
left join StoragesPoints as stp on stp.StoragePointID=mov.StoragePointID join ModelsSizes as mds on mds.ModelSizeID=mov.ModelSizeID where mov.Date<GETDATE()-60 and mov.Date>GETDATE()-365
"
# delete old out file if it exists
If (Test-Path "$outfile"){Remove-Item "$outfile"}

# run sql and export to .csv
Invoke-Sqlcmd -ServerInstance $args[0] -Database $args[1] -Username $args[2] -Password $args[3] -Query $sql | Export-Csv $outfile -Delimiter ";" -Encoding UTF8 -NoTypeInformation 

