# declare sql in a variable and pass it to -Query switch


$outfile = "C:\METALPRO.NET\B2K.NET\Scripts\exportCLF\Export\MOD.csv" # name of file
$sql="select ModelSizeID, mds.ModelID, mds.GarmentSizeID, mds.Code as mod, mdl.Description as moddesc
,mdl.ShortDescription as moddesc2, mdl.fromDate as moddadata, mdl.toDate as modadata, mdl.OccupationSlots as modpris, mdl.Code as modtgrp, grs.OrderPosition as modtpos, grs.Code as modtaglia, mds.TransCodeId as modie,
mdl.ResetDotations as modreset, mdl.TypeEnum as modtipo from ModelsSizes as mds join Models as mdl on mdl.ModelID=mds.ModelID join GarmentSizes as grs on grs.GarmentSizeID=mds.GarmentSizeID"
# delete old out file if it exists
If (Test-Path "$outfile"){Remove-Item "$outfile"}

# run sql and export to .csv
Invoke-Sqlcmd -ServerInstance $args[0] -Database $args[1] -Username $args[2] -Password $args[3] -Query $sql | Export-Csv $outfile -Delimiter ";" -Encoding UTF8 -NoTypeInformation 

