# declare sql in a variable and pass it to -Query switch


$outfile = "C:\METALPRO.NET\B2K.NET\Scripts\exportCLF\Export\MOC.csv" # name of file
$sql="select Slots.SlotID, Slots.StorageID, sto.Code as mocmag, SlotNumber as moccas, SlotStateEnum as moctoc, SlotErrorEnum, Occupation as mocpris, HangDate as mocdata,
Garments.ChipCode as mocart, Garments.ModelSizeID, mds.Code as mocmod, Garments.EmployeeID
from Slots left join Garments on Garments.SlotID=Slots.SlotID join Storages as sto on sto.StorageID=Slots.StorageID left join ModelsSizes as mds on Garments.ModelSizeID=mds.ModelSizeID"
# delete old out file if it exists
If (Test-Path "$outfile"){Remove-Item "$outfile"}

# run sql and export to .csv
Invoke-Sqlcmd -ServerInstance $args[0] -Database $args[1] -Username $args[2] -Password $args[3] -Query $sql | Export-Csv $outfile -Delimiter ";" -Encoding UTF8 -NoTypeInformation 

