# declare sql in a variable and pass it to -Query switch


$outfile = "C:\METALPRO.NET\B2K.NET\Scripts\exportCLF\Export\CLIMAG.csv" # name of file
$sql="SELECT EmployeeGateID, EmployeesGates.EmployeeID, emp.Code as cli, CONCAT(emp.FirstName,' ', emp.LastName) as clinome, stp.Identification 'StoragePointIdentification', stp.Description as 'StoragePointDescription', EmployeesGates.PrimaryEnum
  FROM [B2KNetDB].[dbo].[EmployeesGates] join Gates on Gates.GateID=EmployeesGates.GateID
  join StoragesPoints as stp on Gates.StoragePointID=stp.StoragePointID join Employees as emp on emp.EmployeeID=EmployeesGates.EmployeeID"
# delete old out file if it exists
If (Test-Path "$outfile"){Remove-Item "$outfile"}

# run sql and export to .csv
Invoke-Sqlcmd -ServerInstance $args[0] -Database $args[1] -Username $args[2] -Password $args[3] -Query $sql | Export-Csv $outfile -Delimiter ";" -Encoding UTF8 -NoTypeInformation 

